// Barcode Epidemic 
// V3, Wes, Jan 2017

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class StaticNetworkGraph {
  GregorianCalendar gc = new GregorianCalendar(TimeZone.getDefault());
  
  public int[] getHoursMins(String timestamp) {
    long ts = Long.parseLong(timestamp);
    gc.setTimeInMillis(1000 * ts);
    return new int[] { gc.get(GregorianCalendar.HOUR_OF_DAY),
        gc.get(GregorianCalendar.MINUTE) };
  }

  public void processWebFile(ArrayList<String> data_in, String f_out, String RScript, String RNetGraph, int w, int h, String col1, String col2,String col3,String pngfile) {
    try {
      ArrayList<String> contacts = new ArrayList<String>();
      
      PrintWriter pw = new PrintWriter(new File(f_out));
      pw.println("TimeH,Mins,Infectedby,Seeding,Recency,Category,ID");
      int data_index=0;
      String s;
      if (data_index<data_in.size()) s = data_in.get(data_index++);
      else s=null;

      while (s != null) {
        String[] bits = s.split(",");
        if (bits.length >= 2) {
          // Incoming: infector, timestamp, info, n_Contacts, x,y,z
          int n_contacts = Integer.parseInt(bits[3]);
         
          
                                          // seconds
          String recency_info = "";
          
          long now = System.currentTimeMillis();
          now = (long) now / 1000; // Convert from millis to seconds.
          now -= Long.parseLong(bits[1]); // Difference between now and then in
          recency_info =(Math.abs(now)<900)?"Recent":"Old";        
         
          
          String seed = "N";

          int[] time = getHoursMins(bits[1]);
          int infector = Integer.parseInt(bits[0]);
          if (n_contacts == 0) {
            seed = "X";
          }

          for (int i = 4; i < 4 + n_contacts; i++) {
            contacts.add(bits[i]+"\t"+bits[1]+"\t"+bits[0]);
          }

          boolean done = false;
          for (int j = 0; j < contacts.size(); j++) {
            String[] cbits = contacts.get(j).split("\t");
            int the_contact=Integer.parseInt(cbits[0]);
            
            if (the_contact == infector) {
              int the_infector=Integer.parseInt(cbits[2]);
              pw.println(String.valueOf(time[0]) + "," + String.valueOf(time[1]) + "," + String.valueOf(the_infector) + "," + seed + "," + recency_info+"," + bits[2] + "," + bits[0]);
              contacts.remove(j);
              j = contacts.size();
              done = true;
            }
          }
          if (!done) {
            pw.println(String.valueOf(time[0]) + "," + String.valueOf(time[1]) + ",NA,S," + recency_info+"," + bits[2] + "," + bits[0]);
          }
        }
        if (data_index<data_in.size()) s = data_in.get(data_index++);
        else s=null;
      }
      
      // Add in people who exist, but contacts haven't turned up yet.
      
      for (int i=0; i<contacts.size(); i++) {
        String[] bits = contacts.get(i).split("\t");
        int[] time=getHoursMins(bits[1]);
        
        String recency_info = "";
        
        long now = System.currentTimeMillis();
        now = (long) now / 1000; // Convert from millis to seconds.
        now -= Long.parseLong(bits[1]); // Difference between now and then in
                                        // seconds
        recency_info  = (Math.abs(now)<900)?"Recent":"Old";
          
        pw.println(String.valueOf(time[0])+","+String.valueOf(time[1])+","+bits[2]+",N,"+recency_info+",0,"+bits[0]);
        
      }
      contacts.clear();
      pw.flush();
      pw.close();
      
      try {
        Runtime rt = Runtime.getRuntime();
        String[] bits = new String[] {RScript,RNetGraph,f_out,String.valueOf(w),String.valueOf(h),col1,col2,col3,pngfile};
        rt.exec(bits);
        
      } catch (Exception ex) {
        ex.printStackTrace();
      }

            
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

}