<?php
// Live Epi Server
// Wes Hinsley, 2013
// MRC Centenary Projects
// Updated for short course 2013, 2014
// Updated lots 2017.

// Example (called from Android)
//

// add_infection.php?id=12345&n_contacts=3&contacts=23456,34567,45678
// Declare that person "id" has been infected. He could potentially make 3 contacts, with the given ids.
//
// additionally: &cat=1 may be set - 1=implies DIDE, or VACCINATED, or MALE. 2 implies NOT DIDE, NOT VACCINATED, NOT MALE.
  
// File format: 
// id,timestamp,CATEGORY,no_contacts,contact1,contact2,contact3

  $n_contacts_bit=3;


  $id=$_GET['id'];
  $n_contacts=$_GET['n_contacts'];
  $contacts = explode(",",$_GET['contacts']);
  
  $cat="0";
  if (isset($_GET['cat'])) $cat=$_GET['cat'];
  
  // Just do some sanity checks that everything exists that should do.
  
  // 1. A lock file. Just ensure thread-safe access to the CSV file.
  // Create the file if it doesn't already exist.
  if (!file_exists("epi.lck")) {
    $f = fopen("epi.lck","w");
    fwrite($f,"LOCK");
    fclose($f);
  }

  // Now get the lock.

  $lockfile = fopen("epi.lck","r+");
  if (flock($lockfile,LOCK_EX)) {
    
    // Check we have a CSV file. Trivial, but we might reset the epi by 
    // deleting the CSV file, so it's worth checking.
    
    if (!file_exists("epi.csv")) {
      $f = fopen("epi.csv","w");
      fclose($f);
    }

    // Check for no duplicate record...
    
    $f = fopen("epi.csv","r");
    $dup=0;
    while ((!feof($f)) && ($dup==0)) {
      $s=fgets($f);
      if (strlen($s)>2) {
        $bits=explode(",",$s);
      
      // First check that this person has not reported contacts before.

        if (strcmp($bits[0],$id)==0) $dup=1;      
      
      // Secondly, check the contacts reported have not already been
      // reported as someone else's contacts
        else {
          //$infector=$bits[0];     // Just to remind myself of what's in the file
          //$timestamp=$bits[1];    /  Ditto
          $nc_file=intval($bits[$n_contacts_bit]);           // no. of contacts that the file reports.
          for ($i=$n_contacts_bit; $i<$n_contacts_bit+$nc_file; $i++) {    // Skip infector name, timestamp, and n_contacts
            for ($j=0; $j<$n_contacts; $j++) {
              if (strcmp($contacts[$j],$bits[$i])==0) {   // Found a duplicate.
                $dup=1;           // Set flag
                $j=$n_contacts;   // Abort j loop
                $i=$n_contacts_bit+$nc_file;    // Abort i loop
              }
            }
          }
        }
      }
    }
    fclose($f);
   
    // Append the new details.
    
    $result="DUP";
    if ($dup==0) {
      $result="OK";
      $f = fopen("epi.csv","a");
      $timestamp=time();
      fwrite($f,$id.",".$timestamp.",".$cat.",".$n_contacts);
      for ($i=0; $i<$n_contacts; $i++) {
        fwrite($f,",".$contacts[$i]);
      }
      fwrite($f,"\n");
      fclose($f);    
      flock($lockfile,LOCK_UN);
    }
  }
  fclose($lockfile);
  echo $result;
?>