<?php

// Live Epi Server
// Wes Hinsley, 2013 - updated for MAC December 2016.
// MRC Centenary Projects

// reset.php
// For resetting Vaccination graphs, and the live epidemic.
// Also for querying (from the Ball game) whether a reset has taken place
// And for sending lists of backups to restore.
// 
// Examples: 
//
// reset.php?cmd=query&available=4,time,5,time
// RETURNS: 
//          NO = nothing to delete
//          DEL,3,7 = reset r0=3 and r0=7 - keeping a backup.
//          REST,4,time = restore backup for r0=4
//
// (r0 range = 3..8)
  
  // Check for file existence issues...

  if (!file_exists("reset.lck"))  {
    $f = fopen("reset.lck","w");
    fwrite($f,"LOCK");
    fclose($f);
  }

  $lockfile = fopen("reset.lck","r+");
  if (flock($lockfile,LOCK_EX))  {
    if (!file_exists("reset.txt"))  {
      $f = fopen("reset.txt","w");
      fclose($f);
    }
    flock($lockfile,LOCK_UN);
  }
 
  // And off we go...

  $show_menu=1;
  
  $cmd="";
  $available="";
  if (isset($_GET['cmd'])) $cmd=$_GET['cmd'];

  if (strcmp($cmd,"clear")==0) {
    $lockfile = fopen("reset.lck","r+");
    if (flock($lockfile,LOCK_EX)) {
      $f=fopen("reset.txt","w");
      fwrite($f,"CLEAR\n");
      fclose($f);
      flock($lockfile,LOCK_UN);
    }

  } else if (strcmp($cmd,"restore")==0) {
    $lockfile = fopen("reset.lck","r+");
    if (flock($lockfile,LOCK_EX)) {
      $f=fopen("reset.txt","w");
      fwrite($f,"RESTORE_".$_GET['restore']."\n");
      fclose($f);
      flock($lockfile,LOCK_UN);
    }
  } else if (strcmp($cmd,"clear_epi")==0) {
    $lockfile = fopen("epi.lck","r+");
    if (flock($lockfile,LOCK_EX)) {
      date_default_timezone_set('GMT');
      $backup_folder_name=date("Ymd_His")."/";
      mkdir($backup_folder_name);
      copy("epi.csv",$backup_folder_name."epi.csv");
      unlink("epi.csv");
      copy("nil.txt","epi.csv");
      flock($lockfile,LOCK_UN);
    }
  }
  
  $herd_dirs="";

  $show_menu=1;
  $lockfile=fopen("reset.lck","r+");
  if (flock($lockfile,LOCK_EX)) {
    $f = fopen("reset_dirs.txt","r");
    $s = fgets($f);
    $herd_dirs=explode(",",$s);
    fclose($f);
    flock($lockfile,LOCK_UN);
  }
   
  if ($show_menu==1) {
    $style="style=\"text-align:right; font-family:Calibri; font-size:12pt\"";
    $hstyle="style=\"text-align:right; font-family:Calibri; font-size:13pt; font-weight:bold;\"";
 
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
    <title>MRC Centenary - Centre for Outbreak Analysis and Modelling Centre - Admin</title>
    <script type="text/javascript">
      function clear() {
        if (confirm('Really, backup the data and start new set?')) {
          document.freset.cmd.value='clear';
          document.freset.submit()
        }
      }
      function clearEpi() {
        if (confirm('Really, backup the LIVE EPIDEMIC and start new one?')) {
          document.freset.cmd.value='clear_epi';
          document.freset.submit()
        }
      }
      function restore() {
        if (confirm('Really, lose current data and restore from backup?')) {
          document.freset.cmd.value='restore';
          document.freset.rest.value=document.freset.restore.value;
          document.freset.submit();
        }
      }
    </script>
  </head>
  <body><center>
    <table border="1" cellpadding="1" cellspacing="1"><tr><td width="535"><img src="images/title.png" width="535" height="85"/></td></tr><tr><td><center>
    <form name="freset" action="reset.php" method="get">
      <input type="hidden" name="cmd" value="execute"/>
      <input type="hidden" name="rest" value=""/>
      <table cellspacing="5" cellpadding="3">
        <tr><td <?=$style ?> valign="bottom">Ball Game</td>
            <td valign="bottom"><a href="javascript:clear();">CLEAR</a></td>
            <td valign="bottom"><select name="restore">

<?php

    foreach ($herd_dirs as $herd_dir) {
      $h=base64_decode($herd_dir);
      echo "              <option value=\"".$herd_dir."\">".$h."</option>\n";
    }
?>
            </select>&nbsp;&nbsp;<a href="javascript:restore();">RESTORE</a></td></tr>
        <tr><td <?=$style ?> valign="bottom">Live Epidemic</td>
            <td valign="bottom"><a href="javascript:clearEpi();">CLEAR</a></td>
            <td valign="bottom"></td></tr>
        <tr><td colspan="3" style="text-align:center"><a href="index.php"><img src="images/home.png" alt="home" border="0"/></a></td></tr>
      </table>
     </form></center></td></tr><tr><td width="535"><img src="images/footer.png" width="535" height="85"/></td></tr></table>
  </center></body>
</html>

<?php
  }
?>