<?php
// Live Epi Server
// Wes Hinsley, 2013
// MRC Centenary Projects

// Example (called from Android)
//
// not_yet_contacted.php?id=12345
// Check that this id has not previously been contacted by someone else. 
// This really shouldn't happen! Would imply that we've reycled our infection tickets.
  $contact_bit=3;
  $id=$_GET['id'];
  
  // Just do some sanity checks that everything exists that should do.
  
  // 1. A lock file. Just ensure thread-safe access to the CSV file.
  // Create the file if it doesn't already exist.
  if (!file_exists("epi.lck")) {
    $f = fopen("epi.lck","w");
    fwrite($f,"LOCK");
    fclose($f);
  }

  // Now get the lock.

  $lockfile = fopen("epi.lck","r+");
  if (flock($lockfile,LOCK_EX)) {
    
    // Check we have a CSV file. Trivial, but we might reset the epi by 
    // deleting the CSV file, so it's worth checking.
    
    if (!file_exists("epi.csv")) {
      $f = fopen("epi.csv","w");
      fclose($f);
    }

    // Check for no duplicate record...
    
    $f = fopen("epi.csv","r");
    $dup=0;
    while ((!feof($f)) && ($dup==0)) {
      $s=fgets($f);
      if (strlen($s)>3) {
        $bits=explode(",",$s);
        $nc_file=intval($bits[$contact_bit]);           // no. of contacts that the file reports.
        for ($i=$contact_bit+1; $i<$contact_bit+$nc_file; $i++) {    // Skip infector name, timestamp, and n_contacts
          if (strcmp($id,$bits[$i])==0) {   // Found a duplicate.
            $dup=1;           // Set flag
            $i=$contact_bit+$nc_file;    // Abort i loop
          }
        }
      }
    }
    fclose($f);
   
    // Return either "DUP" or the id it was sent.
    
    $result="DUP";
    if ($dup==0) $result=$id;
    flock($lockfile,LOCK_UN);
  }
  fclose($lockfile);
  echo $result;
?>