<?php
// Herd Immunity Simulator
// Web back-end, called by the main app.
// Wes Hinsley, 2013
// MRC Centenary Projects

// herdsim.php?cmd=next
// herdsim.php?cmd=set_status&msg={WAIT,DEMO,RUN}
// herdsim.php?cmd=hello returns HERD_OK
// herdsim.php?cmd=reset&bkps=[base64 encoded list of directories, comma-separated]

  $cmd="";
  if (isset($_GET['cmd'])) $cmd=$_GET['cmd'];
  
  if (strcmp($cmd,"reset")==0) {
    if (!file_exists("reset.lck")) {
      $f = fopen("reset.lck","w");
      fwrite($f,"LOCK");
      fclose($f);
    }
    $lockfile=fopen("reset.lck","r+");
    if (!file_exists("reset.txt")) {
      $f = fopen("reset.txt","w");
      fwrite($f,"NONE\n");
      fclose($f);
    }

    if (flock($lockfile,LOCK_EX)) {
      $f = fopen("reset_dirs.txt","w");
      fwrite($f,$_GET['bkps']."\n");
      fclose($f);
      $f = fopen("reset.txt","r");
      echo(fgets($f));
      fclose($f);
      $f = fopen("reset.txt","w");
      fwrite($f,"NONE\n");
      fclose($f);
      flock($lockfile,LOCK_UN);
    }
    
  } else {

    // Check lock file exists

    if (!file_exists("herd.lck")) {
      $f = fopen("herd.lck","w");
      fwrite($f,"LOCK");
      fclose($f);
    }
    $lockfile = fopen("herd.lck","r+");

    // "Server alive" sort of thing

    if (strcmp($cmd,"hello")==0) {
      echo "HERD_OK";
  
    } else if (strcmp($cmd,"next")==0) {

      // Get the lock

      if (flock($lockfile,LOCK_EX)) {
 
        // Check that the CSV file exists.

        if (!file_exists("herd.csv")) {
          $f = fopen("herd.csv","w");
          fclose($f);
        }
 
        $f = fopen("herd.csv","r");
        if (!feof($f)) {
          $s=fgets($f);   // Return (and remove) first line.
          if (strlen($s)>2) {
            $fw = fopen("herd2.csv","w");
            while (!feof($f)) {
              fwrite($fw,fgets($f));   // Write other lines to new file
            }
            fclose($f);
            fclose($fw);
            unlink("herd.csv");
            rename("herd2.csv","herd.csv");  // Swap the files
            flock($lockfile,LOCK_UN);
            echo $s;            // And there's the answer.
          } else echo "EMPTY";
        } else {
          echo "EMPTY";
        }
      }
  
    } else if (strcmp($cmd,"set_status")==0) {

      if (flock($lockfile,LOCK_EX)) {
        $f = fopen("herd_status.txt","w");
        fwrite($f,$_GET['msg']."\n");
        fclose($f);
        flock($lockfile,LOCK_UN);
        echo "OK";
      }
    }
  }
?>
