<?php
// Herd Immunity Simulator
// Client for androids to access
// Wes Hinsley, 2013
// MRC Centenary Projects

// herd.php?cmd=get_status            // Current status
// herd.php?cmd=req&r0=5&vacc=50&name=BASE64  // Request a simulation
// herd.php?cmd=req&r0=-1&vacc=-1 // Run demo loop (until next command)

 
 // Check herd.lck, herd_status.txt and herd.csv files exist
    
  if (!file_exists("herd.lck")) {
    $f = fopen("herd.lck","w"); fwrite($f,"LOCK"); fclose($f);
  }

  if (!file_exists("herd.csv")) {
    $f = fopen("herd.csv","w"); fclose($f);
  }

  if (!file_exists("herd_status.txt")) {
    $f = fopen("herd_status.txt","w"); 
    fwrite($f,"UNKNOWN");
    fclose($f);
  }


      // Then get the lock

  $lockfile = fopen("herd.lck","r+");
  
  $cmd="";
  if (isset($_GET['cmd'])) $cmd=$_GET['cmd'];
  if (strlen($cmd)>1) {
    if (strcmp($cmd,"hello")==0) {
      echo "HERD_OK";
 
    } else if (strcmp($cmd,"req")==0) {
      $r0=$_GET['r0'];
      $vacc=$_GET['vacc'];
      $name=$_GET['name']; // base 64 coded but don't mind
     
      if (flock($lockfile,LOCK_EX)) {
        $f = fopen("herd.csv","a");
        fwrite($f,$r0.",".$vacc.",".$name."\n");
        fclose($f);
        if ((intval($r0)==-1) && (intval($vacc)==-1)) {
          $f = fopen("herd_status.txt","w");
          fwrite($f,"DEMO\n");
          fclose($f);
        }
        flock($lockfile,LOCK_UN);
        echo "OK";
      }
    
    } else if (strcmp($cmd,"get_status")==0) {
      if (flock($lockfile,LOCK_EX)) {
        $f = fopen("herd_status.txt","r");
        echo fgets($f);
        fclose($f);
        flock($lockfile,LOCK_UN);
      }
    }
  } 

?>