<?php
// Live Epi Server
// Wes Hinsley, 2013
// MRC Centenary Projects

// unique.php?id=12345
// Return "OK" or "DUP" depending on whether this card has been used for a
// new contact before. Just need to check first entry on each line.
  
  include "r0_sample.php";

  $id=$_GET['id'];
  
  // Check the lock file exists, just to be safe.  
  
  if (!file_exists("epi.lck")) {
    $f = fopen("epi.lck","w");
    fwrite($f,"LOCK");
    fclose($f);
  }

  // And get the lock.

  $lockfile = fopen("epi.lck","r+");
  if (flock($lockfile,LOCK_EX)) {

    // Check that the CSV file exists.

    if (!file_exists("epi.csv")) {
      $f = fopen("epi.csv","w");
      fclose($f);
    }

    // Now open it, and read each line (unless we find a duplicate)

    $f = fopen("epi.csv","r");
    $done=0;
    $result="OK";
    $poi=poisson($r0poi);
    if ($poi>$r0ceil) $poi=$r0ceil;
    if ($poi<$r0floor) $poi=$r0floor;
	$result.=$poi;
    while ((!feof($f)) && ($done==0)) {
      $s = fgets($f); 
      $parts = explode(",", $s);      // Comma-separated string -> array of strings
      if (strcmp($parts[0],$id)==0) { // Found a match?
        $done=1;
        $result="DUP";                // Yup - set the result, and $done=1 aborts the loop
      }
    }
    fclose($f);    
    flock($lockfile,LOCK_UN);
  }
  fclose($lockfile);
  echo $result;

?>