<?php

// Live Epi Server
// Wes Hinsley, 2013
// MRC Centenary Projects

// params.php
// For setting...  
//                   VACC    - probability of a person having been vaccinated.
//                   VACCEFF - probably of the vaccine working.
//                   VACCMUL - If it works, then multiply number of contacts by this.
//                   R0POI   -  Poisson mean for number of contacts
//                   R0CEIL  -  Maximum number of contacts (truncate)
//                   R0FLOOR -  Minimum number of contacts (truncate)
//                   HERDVACC - Whether Herd Immunity app should have a Vaccination button. Y/N
//                   BCVACC - Whether Barcode scanning app should have a Vaccination button. Y/N
// params.php?cmd=get&param=VACC               //  Return current value
// params.php?cmd=set&val=0.1,1.72,5.0,1.0     //  Set (vacc,r0poi,r0ceil,r0floor)
// params.php?cmd=sample&param=VACC            //  Sample vaccination coverage
// params.php?cmd=sample&param=R0              //  Sample R0


  include "r0_sample.php";


  $show_menu=1;

  
  $cmd="";
  $param="";
  if (isset($_GET['cmd'])) $cmd=$_GET['cmd'];
  if (isset($_GET['param'])) $param=$_GET['param'];

  if (isset($_POST['cmd'])) $cmd=$_POST['cmd'];
  if (isset($_POST['param'])) $param=$_POST['param'];

  // SETTING PARAMETERS

  if (strcmp($cmd,"set")==0) {
    $timestamp=time();
    $param=$_GET['param'];
    $vals = explode(",",$_GET['val']);
    $vacc = doubleval($vals[0]);
    $vacceff = doubleval($vals[1]);
    $vaccmul = doubleval($vals[2]);
    $r0poi=doubleval($vals[3]);
    $r0ceil=doubleval($vals[4]);
    $r0floor=doubleval($vals[5]);
    $herdvacc=trim($vals[6]);
    $bcvacc=trim($vals[7]);
    $game_type=trim($vals[8]);
    $lockfile = fopen("params.lck","r+");
    if (flock($lockfile,LOCK_EX))  {
      $f = fopen("params.txt","w");
      fwrite($f,$vacc."\n".$vacceff."\n".$vaccmul."\n".$r0poi."\n".$r0ceil."\n".$r0floor."\n".$herdvacc."\n".$bcvacc."\n".$game_type."\n");
      fclose($f);
      $f = fopen("params_history.txt","a");
      fwrite($f,$timestamp."\t".$vacc."\t".$vacceff."\t".$vaccmul."\t".$r0poi."\t".$r0ceil."\t".$r0floor."\t".$herdvacc."\t".$bcvacc."\t".$game_type."\n");
      fclose($f);
      flock($lockfile,LOCK_UN);
    }
    fclose($lockfile);
    $show_menu=1;

  // GETTING PARAMETERS
    
  } else if  (strcmp($cmd,"get")==0)  {
    $param=$_GET['param'];
    if (strcmp($param,"VACC")==0)  echo $vacc;
    else if (strcmp($param,"VACCEFF")==0)  echo $vacceff;
    else if (strcmp($param,"VACCMUL")==0)  echo $vaccmul;
    else if (strcmp($param,"R0CEIL")==0) echo  $r0ceil;
    else if (strcmp($param,"ALLVAC")==0) echo $vacc."\t".$vacceff."\t".$vaccmul."\t".$bcvacc."\t".$game_type."\t".$r0poi."\t".$r0floor."\t".$r0ceil."\t";
    else if (strcmp($param,"R0POI")==0)  echo $r0poi;
    else if (strcmp($param,"R0FLOOR")==0) echo $r0floor;
    else if (strcmp($param,"GAME")==0) echo $game_type;
    else if (strcmp($param,"HERDVACC")==0) echo $herdvacc;
    else if (strcmp($param,"BCVACC")==0) echo $bcvacc;
    $show_menu=0;
    
  
  // SAMPLING	

  }  else if  (strcmp($cmd,"sample")==0) {
    if (strcmp($param,"VACC")==0)  {
      if (mt_rand()/mt_getrandmax()<$vacc) echo  "YES"; 
      else echo  "NO";
      $show_menu=0;
    } else if  (strcmp($param,"R0")==0) {
      $poi=poisson($r0poi);
      if ($poi>$r0ceil) $poi=$r0ceil;
      if ($poi<$r0floor) $poi=$r0floor;
      echo $poi;
      $show_menu=0;
    }
  }

   
  if ($show_menu==1) {
    $style="style=\"text-align:right; font-family:Calibri; font-size:12pt\"";
    $hstyle="style=\"text-align:right; font-family:Calibri; font-size:13pt; font-weight:bold;\"";
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
    <title>MRC Centenary - Centre for Outbreak Analysis and Modelling Centre - Admin</title>
    <script language="text/javascript" type="text/javascript">
      function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
      }
      function zeroOne(n) {
        return (n>=0) && (n<=1);
      }
      function sendAll() {
        if (!isNumeric(document.fparams.vacc.value)) alert('Vaccination probability is not numerical!');
        else if (!isNumeric(document.fparams.vacceff.value)) alert('Vaccination efficacy is not numerical!');
        else if (!isNumeric(document.fparams.vaccmul.value)) alert('Vaccination multiplier is not numerical!');
        else if (!isNumeric(document.fparams.r0poi.value)) alert('R0 is not numerical!');
        else if (!isNumeric(document.fparams.r0ceil.value)) alert('R0 ceiling is not numerical!');
        else if (!isNumeric(document.fparams.r0floor.value)) alert('R0 floor is not numerical!');
        else if (!zeroOne(document.fparams.vacc.value)) alert('Vaccination probability out of range!');
        else if (!zeroOne(document.fparams.vacceff.value)) alert('Vaccination efficacy out of range!');
        else if (!zeroOne(document.fparams.vaccmul.value)) alert('Vaccination multiplier out of range!');
        else {
          document.fparams.val.value=document.fparams.vacc.value+','+document.fparams.vacceff.value+","+document.fparams.vaccmul.value+","+document.fparams.r0poi.value+','+document.fparams.r0ceil.value+','+document.fparams.r0floor.value+','+document.fparams.herdvacc.value+","+document.fparams.bcvacc.value+","+document.fparams.game_type.value;
          document.fparams.submit();
        }
      }
    </script>
  </head>
  <body><center>
    <table border="1" cellpadding="1" cellspacing="1"><tr><td width="535"><img src="images/title.png" width="535" height="85"/></td></tr><tr><td><center>
    <form name="fparams" action="params.php" method="get">
      <input type="hidden" name="cmd" value="set"/>
      <input type="hidden" name="val" value=""/>
      <input type="hidden" name="param" value=""/>
      <table cellspacing="5" cellpadding="3">
        <tr><td <?=$hstyle ?>>Parameter</td><td <?=$hstyle ?>>Old Value</td><td <?=$hstyle ?>">New Value</td><td></td></tr>
        <tr><td <?=$style ?>>R0 poisson mean</td><td><center><?=$r0poi ?></center></td><td><input type="text" name="r0poi" value="<?=$r0poi ?>"/></td><td></td></tr>
        <tr><td <?=$style ?>>R0 ceiling</td><td><center><?=$r0ceil ?></center></td><td><input type="text" name="r0ceil" value="<?=$r0ceil ?>"/></td><td></td></tr>
        <tr><td <?=$style ?>>R0 floor</td><td><center><?=$r0floor ?></center></td><td><input type="text" name="r0floor" value="<?=$r0floor ?>"/></td><td></td></tr>
        <tr><td colspan="3"><hr/></td></tr>
        <tr><td <?=$style ?>>Vaccination Probability</td><td><center><?=$vacc ?></center></td><td><input type="text" name="vacc" value="<?=$vacc ?>"/></td><td></td></tr>
        <tr><td <?=$style ?>>Vaccination Efficacy</td><td><center><?=$vacceff ?></center></td><td><input type="text" name="vacceff" value="<?=$vacceff ?>"/></td><td></td></tr>
        <tr><td <?=$style ?>>Vaccination Contact-Multiplier</td><td><center><?=$vaccmul ?></center></td><td><input type="text" name="vaccmul" value="<?=$vaccmul ?>"/></td><td></td></tr>
        <tr><td colspan="3"><hr/></td></tr>
        <tr><td style="font-weight:bold;font-family:Calibri,Arial" colspan="3">App Settings</td></tr>


        <tr><td <?=$style ?>>Herd game: Vacc button</td><td><center><?php if (strcmp($herdvacc,"Y")===0) echo "YES"; else echo "NO";?></center></td><td><select name="herdvacc">
          <option <?php if (strcmp($herdvacc,"Y")===0) echo "selected "; ?>value="Y">Yes</option>
          <option <?php if (strcmp($herdvacc,"N")===0) echo "selected "; ?>value="N">No</option></select></td><td></td></tr>
        <tr><td <?=$style ?>>Barcode game: Vacc button</td><td><center><?php if (strcmp($bcvacc,"Y")===0) echo "YES"; else echo "NO";?></center></td><td><select name="bcvacc">
          <option <?php if (strcmp($bcvacc,"Y")===0) echo "selected "; ?>value="Y">Yes</option>
          <option <?php if (strcmp($bcvacc,"N")===0) echo "selected "; ?>value="N">No</option></select></td><td></td></tr>
        <tr><td <?=$style ?>>Population Division (Game-type):</td><td><center><?php 
          if (strcmp($game_type,"N")===0) echo "None"; 
          else if (strcmp($game_type,"D")===0) echo "Departmental"; 
          else if (strcmp($game_type,"G")===0) echo "Gender"; 
          else if (strcmp($game_type,"V")===0) echo "Vaccination";?></center></td><td><select name="game_type">
          <option <?php if (strcmp($game_type,"N")===0) echo "selected"; ?> value="N">None</option>
          <option <?php if (strcmp($game_type,"D")===0) echo "selected"; ?> value="D">Departmental</option>
          <option <?php if (strcmp($game_type,"G")===0) echo "selected"; ?> value="G">Gender</option>
          <option <?php if (strcmp($game_type,"V")===0) echo "selected"; ?> value="V">Vaccination</option></select></td><td></td></tr>

       </table><table><tr><td height="20"><center><a href="index.php"><img src="images/home.png" alt="Home" border="0"/></a>&nbsp;&nbsp;<a href="javascript:sendAll();"><img src="images/set.png" alt="Set" border="0"/></a></center></td></tr></table>
    </form></center></td></tr><tr><td width="535"><img src="images/footer.png" width="535" height="85"/></td></tr></table>
  </body>
</html>
    
<?php

  }

?>