import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;

import javax.imageio.ImageIO;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;

@SuppressWarnings("serial")
public class QRMake extends JFrame {
  // Print parameters
  PrintRequestAttributeSet pras; 
  PrintService[] pss;
  PrintService chosenPrinter;
  String out_img="_page.png";
  String tmp_img="_tmp_qr.png";
  
  // GUI components
  
  JButton bPrint;
  JTextField tfFirst,tfLast,tfLabelX,tfLabelY,tfPageW,tfPageH,tfBCX,tfBCY,tfTX,tfTY,tfPerSheet,tfPreAmble,tfBackImg,tfFontSize;
  JComboBox<String> cbPrinters;
  JTextField tfPX,tfPY;
  PageFormat pageformat;
  
  public void make(String msg, String outf) {
    ByteArrayOutputStream out = QRCode.from(msg).to(ImageType.PNG).stream();
    try {
      FileOutputStream fout = new FileOutputStream(new File(outf));
      fout.write(out.toByteArray());
      fout.flush();
      fout.close();
      
    } catch (Exception e) { e.printStackTrace(); }
  }
  

  public void makePage(Graphics pg, int barcode_id) throws Exception {
 
    // Create a load of barcodes on an image, and print them!
    
    int page_w=Integer.parseInt(tfPageW.getText());
    int page_h=Integer.parseInt(tfPageH.getText());
    String back_img=tfBackImg.getText();
    int no_per_sheet=Integer.parseInt(tfPerSheet.getText());
    int bc_x=Integer.parseInt(tfBCX.getText());
    int bc_y=Integer.parseInt(tfBCY.getText());
    int txt_x=Integer.parseInt(tfTX.getText());
    int txt_y=Integer.parseInt(tfTY.getText());
    String pre_amble=tfPreAmble.getText();
    int label_x=Integer.parseInt(tfLabelX.getText());
    int label_y=Integer.parseInt(tfLabelY.getText());
    
    
    int x=0;
    int y=0;
    
    BufferedImage bi = new BufferedImage(page_w,page_h,BufferedImage.TYPE_4BYTE_ABGR);
    Graphics2D G = (Graphics2D) bi.getGraphics();
    G.setColor(Color.WHITE);
    G.fillRect(0, 0, page_w, page_h);
    G.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

    BufferedImage bg = ImageIO.read(new File(back_img));
    int i=0;
    while (i<no_per_sheet) {
      i++;
      make(pre_amble+String.valueOf(barcode_id),tmp_img);
      BufferedImage bc = ImageIO.read(new File(tmp_img));
      int bc_width = bc.getWidth();
      int bc_height = bc.getHeight();
      G.drawImage(bg,x,y,null);
      G.setColor(new Color(0,0,0,255));
      
      for (int ii=0; ii<bc_width; ii++) {
        for (int jj=0; jj<bc_height; jj++) {
          int rgb = bc.getRGB(ii, jj);
          if (rgb<-10) {
            G.fillRect(x+bc_x+(int)(ii*2),y+bc_y+(int)(jj*2),2,2);  
          }
        }
      }
      G.setColor(new Color(0,0,0));
      Font f = new Font("Calibri",Font.BOLD,Integer.parseInt(tfFontSize.getText()));
      G.setFont(f);
      FontMetrics fm = G.getFontMetrics();
      int wid=fm.stringWidth(String.valueOf(barcode_id));
      G.drawString(String.valueOf(barcode_id),x+(txt_x-wid),y+txt_y);
      
      // Next barcode
      barcode_id++;
      x+=label_x;
      if (x+label_x>page_w+50) {
        x=0;
        y+=label_y;
        if (y+label_y>page_h) {
          // Next page
          y=0;
        }
      }
    }
    //pg.drawImage(bi, 0, 0, page_w, page_h,null);
    ImageIO.write(bi, "PNG", new File(out_img));
  }
  
  public void addPanel(Container p, String s, JComponent t) {
    JPanel n = new JPanel();
    JLabel l = new JLabel(s);
    n.setLayout(new FlowLayout());
    l.setPreferredSize(new Dimension(150,25));
    l.setAlignmentX(JLabel.RIGHT_ALIGNMENT);
    t.setPreferredSize(new Dimension(200,25));
    n.add(l);
    n.add(t);
    p.add(n);
  }
  
  
  public void readIni() {
    try {
      BufferedReader br = new BufferedReader(new FileReader("qrmake.ini"));
      tfFirst.setText(br.readLine());
      tfLast.setText(br.readLine());
      tfLabelX.setText(br.readLine());
      tfLabelY.setText(br.readLine());
      tfPageW.setText(br.readLine());
      tfPageH.setText(br.readLine());
      tfBCX.setText(br.readLine());
      tfBCY.setText(br.readLine());
      tfTX.setText(br.readLine());
      tfTY.setText(br.readLine());
      tfPerSheet.setText(br.readLine());
      tfPreAmble.setText(br.readLine());
      tfBackImg.setText(br.readLine());
      tfPX.setText(br.readLine());
      tfPY.setText(br.readLine());
      tfFontSize.setText(br.readLine());
      br.close();
      
    } catch (Exception e) { e.printStackTrace(); }
  }
  
  public void saveIni() {
    try {
      PrintWriter PW = new PrintWriter(new File("qrmake.ini"));
      PW.println(tfFirst.getText());
      PW.println(tfLast.getText());
      PW.println(tfLabelX.getText());
      PW.println(tfLabelY.getText());
      PW.println(tfPageW.getText());
      PW.println(tfPageH.getText());
      PW.println(tfBCX.getText());
      PW.println(tfBCY.getText());
      PW.println(tfTX.getText());
      PW.println(tfTY.getText());
      PW.println(tfPerSheet.getText());
      PW.println(tfPreAmble.getText());
      PW.println(tfBackImg.getText());
      PW.println(tfPX.getText());
      PW.println(tfPY.getText());
      PW.println(tfFontSize.getText());
      PW.close();
      
    } catch (Exception e) { e.printStackTrace(); }
  }
  
  public QRMake() throws Exception {
    //makePage(null, 1000);
    
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setSize(new Dimension(400,200));
    setTitle("Live Epidemic Barcode Printer");
    getContentPane().setLayout(new GridLayout(19,1));
    tfFirst=new JTextField();
    tfLast=new JTextField();
    tfLabelX=new JTextField();
    tfLabelY=new JTextField();
    tfPageW=new JTextField();
    tfPageH=new JTextField();
    tfBCX=new JTextField();
    tfBCY=new JTextField();
    tfTX=new JTextField();
    tfTY=new JTextField();
    tfPerSheet=new JTextField();
    tfPreAmble=new JTextField();
    tfBackImg=new JTextField();
    tfPX=new JTextField();
    tfPY=new JTextField();
    tfFontSize=new JTextField();
    readIni();
    addPanel(getContentPane(),"First Bar-Code No",tfFirst);
    addPanel(getContentPane(),"Last Bar-Code No",tfLast);
    addPanel(getContentPane(),"Label spacing x (10*mm)",tfLabelX);
    addPanel(getContentPane(),"Label spacing y(10*mm)",tfLabelY);
    addPanel(getContentPane(),"Total labels width(10*mm)",tfPageW);
    addPanel(getContentPane(),"Total labels height(10*mm)",tfPageH);
    addPanel(getContentPane(),"Bar Code offset X (10*mm)",tfBCX);
    addPanel(getContentPane(),"Bar Code offset Y (10*mm)",tfBCY);
    addPanel(getContentPane(),"Text offset X (10*mm)",tfTX);
    addPanel(getContentPane(),"Text offset Y (10*mm)",tfTY);
    addPanel(getContentPane(),"Font Size",tfFontSize);
    addPanel(getContentPane(),"Labels per sheet",tfPerSheet);
    addPanel(getContentPane(),"URL preamble",tfPreAmble);
    addPanel(getContentPane(),"Background img",tfBackImg);
    
    pras = new HashPrintRequestAttributeSet();
    pras.add(new Copies(1));
    pss = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.PNG, pras);
    String[] printers = new String[pss.length];
    for (int i=0; i<printers.length; i++) printers[i]=new String(pss[i].getName());
    cbPrinters = new JComboBox<String>(printers);
    
    addPanel(getContentPane(),"Printer",cbPrinters);
    addPanel(getContentPane(),"Print at X (mm)",tfPX);
    addPanel(getContentPane(),"Print at Y (mm)",tfPY);
    bPrint=new JButton("Print");
    EventHandler eh = new EventHandler();
    bPrint.addActionListener(eh);
    addPanel(getContentPane(),"Go",bPrint);

    pack();
    
  }
  
  
  
  public static void main(String[] args) throws Exception {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        try {
          QRMake q = new QRMake();
          q.setVisible(true);
        } catch (Exception e) { e.printStackTrace(); }
      }
    });
    
  }

  class EventHandler implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if (e.getSource()==bPrint) {
        saveIni();
        bPrint.setEnabled(false);
        bPrint.paint(bPrint.getGraphics());
        int start=Integer.parseInt(tfFirst.getText());
        int end=Integer.parseInt(tfLast.getText());
        int per_sheet=Integer.parseInt(tfPerSheet.getText());
        int page=0;
        chosenPrinter=pss[cbPrinters.getSelectedIndex()];
        for (int i=start; i<=end; i+=per_sheet) {
          try {
            bPrint.setText("Printing "+start+".."+(start+per_sheet));
            bPrint.paint(bPrint.getGraphics());
            out_img="_print_bc_page"+page+".png";
            makePage(null,i);
            
            
            pras.clear();
            pras.add(new Copies(1));
            MediaPrintableArea mpa = new MediaPrintableArea(Integer.parseInt(tfPX.getText()),Integer.parseInt(tfPY.getText()),Integer.parseInt(tfPageW.getText())/10,Integer.parseInt(tfPageH.getText())/10,MediaPrintableArea.MM);
            pras.add(mpa);
            pras.add(MediaSizeName.ISO_A4);
            DocPrintJob job = chosenPrinter.createPrintJob();
            FileInputStream fin = new FileInputStream(out_img);
            Doc doc = new SimpleDoc(fin, DocFlavor.INPUT_STREAM.PNG, null);
            job.print(doc, pras);
            fin.close();
            new File(out_img).delete();
            
            
          } catch (Exception ex) { ex.printStackTrace(); }
        }
        bPrint.setEnabled(true);
        bPrint.setText("Done! (Print Again)");
      }
    }
  }
}
