/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.exception.QRGenerationException;
import net.glxn.qrgen.image.ImageType;

public class QRCode {
    private final String text;
    private ImageType imageType = ImageType.PNG;
    private int width = 125;
    private int height = 125;

    private QRCode(String text) {
        this.text = text;
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public QRCode to(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public QRCode withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToFile((BitMatrix)this.createMatrix(), (String)this.imageType.toString(), (File)file);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
        return file;
    }

    public ByteArrayOutputStream stream() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            MatrixToImageWriter.writeToStream((BitMatrix)this.createMatrix(), (String)this.imageType.toString(), (OutputStream)stream);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
        return stream;
    }

    private BitMatrix createMatrix() throws WriterException {
        return new QRCodeWriter().encode(this.text, BarcodeFormat.QR_CODE, this.width, this.height);
    }

    private File createTempFile() throws IOException {
        File file = File.createTempFile("QRCode", "." + this.imageType.toString().toLowerCase());
        file.deleteOnExit();
        return file;
    }
}

