/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class Code39Writer
extends UPCEANWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public byte[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        int[] widths = new int[9];
        int codeWidth = 25 + length;
        for (int i = 0; i < length; ++i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(contents.charAt(i));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[indexInString], widths);
            for (int j = 0; j < widths.length; ++j) {
                codeWidth += widths[j];
            }
        }
        byte[] result = new byte[codeWidth];
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], widths);
        int pos = Code39Writer.appendPattern(result, 0, widths, 1);
        int[] narrowWhite = new int[]{1};
        pos += Code39Writer.appendPattern(result, pos, narrowWhite, 0);
        for (int i = length - 1; i >= 0; --i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(contents.charAt(i));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[indexInString], widths);
            pos += Code39Writer.appendPattern(result, pos, widths, 1);
            pos += Code39Writer.appendPattern(result, pos, narrowWhite, 0);
        }
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], widths);
        pos += Code39Writer.appendPattern(result, pos, widths, 1);
        return result;
    }

    private static void toIntArray(int a, int[] toReturn) {
        for (int i = 0; i < 9; ++i) {
            int temp = a & 1 << i;
            toReturn[i] = temp == 0 ? 1 : 2;
        }
    }
}

