/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class URIParsedResult
extends ParsedResult {
    private final String uri;
    private final String title;

    public URIParsedResult(String uri, String title) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(uri);
        this.title = title;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return this.containsUser();
    }

    private boolean containsUser() {
        int at;
        int hostStart = this.uri.indexOf(58);
        ++hostStart;
        int uriLength = this.uri.length();
        while (hostStart < uriLength && this.uri.charAt(hostStart) == '/') {
            ++hostStart;
        }
        int hostEnd = this.uri.indexOf(47, hostStart);
        if (hostEnd < 0) {
            hostEnd = uriLength;
        }
        return (at = this.uri.indexOf(64, hostStart)) >= hostStart && at < hostEnd;
    }

    @Override
    public String getDisplayResult() {
        StringBuffer result = new StringBuffer(30);
        URIParsedResult.maybeAppend(this.title, result);
        URIParsedResult.maybeAppend(this.uri, result);
        return result.toString();
    }

    private static String massageURI(String uri) {
        int protocolEnd = (uri = uri.trim()).indexOf(58);
        uri = protocolEnd < 0 ? "http://" + uri : (URIParsedResult.isColonFollowedByPortNumber(uri, protocolEnd) ? "http://" + uri : uri.substring(0, protocolEnd).toLowerCase() + uri.substring(protocolEnd));
        return uri;
    }

    private static boolean isColonFollowedByPortNumber(String uri, int protocolEnd) {
        int nextSlash = uri.indexOf(47, protocolEnd + 1);
        if (nextSlash < 0) {
            nextSlash = uri.length();
        }
        if (nextSlash <= protocolEnd + 1) {
            return false;
        }
        for (int x = protocolEnd + 1; x < nextSlash; ++x) {
            if (uri.charAt(x) >= '0' && uri.charAt(x) <= '9') continue;
            return false;
        }
        return true;
    }
}

