/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeThread;
import com.google.zxing.client.j2se.Inputs;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public final class CommandLineRunner {
    private CommandLineRunner() {
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        Inputs inputs = new Inputs();
        for (String arg : args) {
            if ("--try_harder".equals(arg)) {
                config.setTryHarder(true);
                continue;
            }
            if ("--pure_barcode".equals(arg)) {
                config.setPureBarcode(true);
                continue;
            }
            if ("--products_only".equals(arg)) {
                config.setProductsOnly(true);
                continue;
            }
            if ("--dump_results".equals(arg)) {
                config.setDumpResults(true);
                continue;
            }
            if ("--dump_black_point".equals(arg)) {
                config.setDumpBlackPoint(true);
                continue;
            }
            if ("--multi".equals(arg)) {
                config.setMulti(true);
                continue;
            }
            if ("--brief".equals(arg)) {
                config.setBrief(true);
                continue;
            }
            if ("--recursive".equals(arg)) {
                config.setRecursive(true);
                continue;
            }
            if (arg.startsWith("--crop")) {
                int[] crop = new int[4];
                String[] tokens = arg.substring(7).split(",");
                for (int i = 0; i < config.getCrop().length; ++i) {
                    crop[i] = Integer.parseInt(tokens[i]);
                }
                config.setCrop(crop);
                continue;
            }
            if (arg.startsWith("--threads") && arg.length() >= 10) {
                int threads = Integer.parseInt(arg.substring(10));
                if (threads <= 1) continue;
                config.setThreads(threads);
                continue;
            }
            if (!arg.startsWith("-")) continue;
            System.err.println("Unknown command line option " + arg);
            CommandLineRunner.printUsage();
            return;
        }
        config.setHints(CommandLineRunner.buildHints(config));
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            CommandLineRunner.addArgumentToInputs(arg, config, inputs);
        }
        ArrayList<DecodeThread> threads = new ArrayList<DecodeThread>(config.getThreads());
        for (int x = 0; x < config.getThreads(); ++x) {
            DecodeThread thread = new DecodeThread(config, inputs);
            threads.add(thread);
            thread.start();
        }
        int successful = 0;
        for (int x = 0; x < config.getThreads(); ++x) {
            ((DecodeThread)threads.get(x)).join();
            successful += ((DecodeThread)threads.get(x)).getSuccessful();
        }
        int total = inputs.getInputCount();
        if (total > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
        }
    }

    private static void addArgumentToInputs(String argument, Config config, Inputs inputs) {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                for (File singleFile : inputFile.listFiles()) {
                    String filename = singleFile.getName().toLowerCase(Locale.ENGLISH);
                    if (filename.startsWith(".")) continue;
                    if (singleFile.isDirectory()) {
                        if (!config.isRecursive()) continue;
                        CommandLineRunner.addArgumentToInputs(singleFile.getAbsolutePath(), config, inputs);
                        continue;
                    }
                    if (filename.endsWith(".txt") || filename.contains(".mono.png")) continue;
                    inputs.addInput(singleFile.getAbsolutePath());
                }
            } else {
                inputs.addInput(inputFile.getAbsolutePath());
            }
        } else {
            inputs.addInput(argument);
        }
    }

    private static Hashtable<DecodeHintType, Object> buildHints(Config config) {
        Hashtable<DecodeHintType, Object> hints = new Hashtable<DecodeHintType, Object>(3);
        Vector<BarcodeFormat> vector = new Vector<BarcodeFormat>(8);
        vector.addElement(BarcodeFormat.UPC_A);
        vector.addElement(BarcodeFormat.UPC_E);
        vector.addElement(BarcodeFormat.EAN_13);
        vector.addElement(BarcodeFormat.EAN_8);
        vector.addElement(BarcodeFormat.RSS_14);
        vector.addElement(BarcodeFormat.RSS_EXPANDED);
        if (!config.isProductsOnly()) {
            vector.addElement(BarcodeFormat.CODE_39);
            vector.addElement(BarcodeFormat.CODE_93);
            vector.addElement(BarcodeFormat.CODE_128);
            vector.addElement(BarcodeFormat.ITF);
            vector.addElement(BarcodeFormat.QR_CODE);
            vector.addElement(BarcodeFormat.DATA_MATRIX);
            vector.addElement(BarcodeFormat.AZTEC);
            vector.addElement(BarcodeFormat.PDF_417);
            vector.addElement(BarcodeFormat.CODABAR);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, vector);
        if (config.isTryHarder()) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        System.err.println("  --threads=n: The number of threads to use while decoding");
    }
}

